package gov.va.med.mhv.journal.repository;

import gov.va.med.mhv.journal.data.model.FoodJournal;

import java.util.Date;
import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface FoodJournalRepository extends JpaRepository<FoodJournal, Long> {

	@Query("select j " +
			"from FoodJournal j " +
			"where j.userId = :userId " +
			"order by j.journalDate desc")
	public List<FoodJournal> findFoodJournalsForUser(@Param("userId") Long userId);
	
	@Query("select j " +
			"from FoodJournal j " +
			"where j.userId = :userId " +
			"order by j.journalDate desc")
	public List<FoodJournal> getDashBoardFoodJournalsForUser(@Param("userId") Long userId, Pageable page);

	@Query("select j " +
			"from FoodJournal j " +
			"where j.userId = :userId " +
			"and j.journalDate = :journalDate")
	public List<FoodJournal> findFoodJournalsForUserAndDate(@Param("userId") Long userId, @Param("journalDate") Date journalDate);
}
